/****************************************
* ArtemisHscAPI.cpp
*
* This file is autogenerated.
*
****************************************/

#pragma once
#include <string>
#include <iostream>
#include "AtikCameras.h"

//////////////////////////////////////////////////////////////////////////
//
// Interface functions for Artemis Camera Library
//

#ifdef _WIN32	
#define WIN32_LEAN_AND_MEAN
#define NOMINMAX
#include <windows.h>
#include <comdef.h>	
#else
#include <dlfcn.h>
typedef void * FARPROC;
typedef void * HINSTANCE;
typedef void * HWND;
typedef void * VARIANT;
#define __stdcall
#endif

#define artfn /* */

// Names:
// V = void
// B = bool
// b = bool *
// I = int
// i = int *
// S = char *
// C = const char *
// H = ArtemisHandle

typedef bool(__stdcall * AtikMethod_B)();
typedef int (__stdcall * AtikMethod_I)();

typedef void(__stdcall * AtikMethod_V)();
typedef void(__stdcall * AtikMethod_V_B)(bool);
typedef void(__stdcall * AtikMethod_V_C)(const char *);
typedef void(__stdcall * AtikMethod_V_CI)(const char *, int);

typedef bool(__stdcall *AtikMethod_B_IS)(int, char *);
typedef bool(__stdcall *AtikMethod_B_HI)(ArtemisHandle, int);

typedef int(__stdcall *AtikMethod_I_H)(		 ArtemisHandle);
typedef int(__stdcall *AtikMethod_I_HB)(	 ArtemisHandle, bool);
typedef int(__stdcall *AtikMethod_I_HBBBHPS)(	 ArtemisHandle, bool, bool, bool, HotPixelSensitivity);
typedef int(__stdcall *AtikMethod_I_Hb)(	 ArtemisHandle, bool *);
typedef int(__stdcall *AtikMethod_I_HI)(	 ArtemisHandle, int);
typedef int(__stdcall *AtikMethod_I_Hi)(	 ArtemisHandle, int *);
typedef int(__stdcall *AtikMethod_I_Hib)(	 ArtemisHandle, int *, bool *);
typedef int(__stdcall *AtikMethod_I_HIi)(	 ArtemisHandle, int, int *);
typedef int(__stdcall *AtikMethod_I_HF)(	 ArtemisHandle, float);
typedef int(__stdcall *AtikMethod_I_Hf)(	 ArtemisHandle, float *);
typedef int(__stdcall *AtikMethod_I_HII)(	 ArtemisHandle, int,   int);
typedef int(__stdcall *AtikMethod_I_HIIII)(	 ArtemisHandle, int,   int, int, int);
typedef int(__stdcall *AtikMethod_I_HIIIII)( ArtemisHandle, int,   int, int, int, int);
typedef int(__stdcall *AtikMethod_I_Hii)(	 ArtemisHandle, int *, int *);
typedef int(__stdcall *AtikMethod_I_Hiiii)(	 ArtemisHandle, int *, int *, int *, int *);
typedef int(__stdcall *AtikMethod_I_Hiiiii)( ArtemisHandle, int *, int *, int *, int *, int *);
typedef int(__stdcall *AtikMethod_I_Hiiiiii)(ArtemisHandle, int *, int *, int *, int *, int *, int *);



typedef int(__stdcall *AtikMethod_I_HBii)(ArtemisHandle, bool, int*, int*);
typedef int(__stdcall *AtikMethod_I_HBII)(ArtemisHandle, bool, int,  int);

typedef float(__stdcall *AtikMethod_F_H)(ArtemisHandle);

typedef char* (__stdcall *AtikMethod_S_H)(ArtemisHandle);

typedef bool         (__stdcall * AtikMethod_B_I)(int);
typedef ArtemisHandle(__stdcall * AtikMethod_H_I)(int);
typedef bool         (__stdcall * AtikMethod_B_H)(ArtemisHandle);

typedef bool(__stdcall * AtikMethod_B_HIS)(ArtemisHandle, int, char*);
typedef bool(__stdcall * AtikMethod_B_HSS)(ArtemisHandle, char*,char*);

typedef int(__stdcall *AtikMethod_I_HIS)(ArtemisHandle, int, char*);
typedef int(__stdcall *AtikMethod_I_HSS)(ArtemisHandle, char*, char*);


typedef void(__stdcall * AtikMethod_ArtemisSetDebugCallback)(void(*callback)(const char *message));
typedef void(__stdcall * AtikMethod_ArtemisSetDebugCallbackContext)(void * context, void(*callback)(void * context, const char *message));

typedef bool(__stdcall * AtikMethod_ArtemisSetSetFastCallback)(ArtemisHandle, void(*callback)(ArtemisHandle handle, int x, int y, int w, int h, int binx, int biny, void * imageBuffer));

typedef int(__stdcall * AtikMethod_ArtemisColourProperties)(     ArtemisHandle, ARTEMISCOLOURTYPE *, int *, int *, int *, int *);
typedef int(__stdcall * AtikMethod_ArtemisProperties)(		   ArtemisHandle, struct ARTEMISPROPERTIES *);
typedef int(__stdcall * AtikMethod_ArtemisCameraConnectionState)(ArtemisHandle, ARTEMISCONNECTIONSTATE *);

typedef void* (__stdcall *AtikMethod_ArtemisImageBuffer)(ArtemisHandle);

typedef bool(__stdcall *AtikMethod_ArtemisHasCameraSpecificOption)(    ArtemisHandle, unsigned short);
typedef int (__stdcall *AtikMethod_ArtemisCameraSpecificOptionGetData)(ArtemisHandle, unsigned short, unsigned char *, int, int &);
typedef int (__stdcall *AtikMethod_ArtemisCameraSpecificOptionSetData)(ArtemisHandle, unsigned short, unsigned char *, int);

typedef int(__stdcall *AtikMethod_ArtemisSetColumnRepairColumns)(ArtemisHandle, int,   unsigned short *);
typedef int(__stdcall *AtikMethod_ArtemisGetColumnRepairColumns)(ArtemisHandle, int *, unsigned short *);

typedef int(__stdcall *AtikMethod_ArtemisWriteToEEPROM)( ArtemisHandle, char *, int, int, const unsigned char *);
typedef int(__stdcall *AtikMethod_ArtemisReadFromEEPROM)(ArtemisHandle, char *, int, int, unsigned char *);

typedef int(__stdcall *AtikMethod_ArtemisEFWGetDeviceDetails)(int, ARTEMISEFWTYPE *, char *);
typedef int(__stdcall *AtikMethod_ArtemisEFWGetDetails)(ArtemisHandle, ARTEMISEFWTYPE *, char *);

extern "C"
{
#ifndef _WIN32
	static void * GetProcAddress(HINSTANCE hArtemisDLL, const char * method)
	{
		return dlsym(hArtemisDLL, method);
	}
#endif

	HINSTANCE hArtemisDLL = NULL;

	// -------------------  DLL --------------------------
	artfn int  ArtemisAPIVersion()
	{
		static AtikMethod_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_I)GetProcAddress(hArtemisDLL, "ArtemisAPIVersion");

		if (method == NULL)
			return -1;

		return method();
	}
	artfn int  ArtemisDLLVersion()
	{
		static AtikMethod_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_I)GetProcAddress(hArtemisDLL, "ArtemisDLLVersion");

		if (method == NULL)
			return -1;

		return method();
	}
	artfn BOOL ArtemisIsLocalConnection()
	{
		static AtikMethod_B method = NULL;

		if (method == NULL)
			method = (AtikMethod_B)GetProcAddress(hArtemisDLL, "ArtemisIsLocalConnection");

		if (method == NULL)
			return -1;

		return method();
	}
	artfn void ArtemisAllowDebugToConsole(bool value)
	{
		static AtikMethod_V_B method = NULL;

		if (method == NULL)
			method = (AtikMethod_V_B)GetProcAddress(hArtemisDLL, "ArtemisAllowDebugToConsole");

		if (method == NULL)
			return;

		method(value);
	}
	artfn void ArtemisSetDebugCallback(void(*callback)(const char *message))
	{
		static AtikMethod_ArtemisSetDebugCallback method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisSetDebugCallback)GetProcAddress(hArtemisDLL, "ArtemisSetDebugCallback");

		if (method == NULL)
			return;

		method(callback);
	}
	artfn void ArtemisSetDebugCallbackContext(void * context, void(*callback)(void * context, const char *message))
	{
		static AtikMethod_ArtemisSetDebugCallbackContext method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisSetDebugCallbackContext)GetProcAddress(hArtemisDLL, "ArtemisSetDebugCallbackContext");

		if (method == NULL)
			return;

		method(context, callback);
	}
	artfn void ArtemisSetFirmwareDir(const char * firmwareDir)
	{
		static AtikMethod_V_C method = NULL;

		if (method == NULL)
			method = (AtikMethod_V_C)GetProcAddress(hArtemisDLL, "ArtemisSetFirmwareDir");

		if (method == NULL)
			return;

		method(firmwareDir);
	}
	artfn void ArtemisSetAtikAir(const char * host, int port)
	{
		static AtikMethod_V_CI method = NULL;

		if (method == NULL)
			method = (AtikMethod_V_CI)GetProcAddress(hArtemisDLL, "ArtemisSetAtikAir");

		if (method == NULL)
			return;

		method(host, port);
	}
	artfn void ArtemisShutdown()
	{
		static AtikMethod_V method = NULL;

		if (method == NULL)
			method = (AtikMethod_V)GetProcAddress(hArtemisDLL, "ArtemisShutdown");

		if (method == NULL)
			return;

		method();
	}

	// -------------------  Device --------------------------
	artfn int			ArtemisDeviceCount()
	{
		static AtikMethod_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_I)GetProcAddress(hArtemisDLL, "ArtemisDeviceCount");

		if (method == NULL)
			return -1;

		return method();
	}
	artfn BOOL			ArtemisDeviceIsPresent(int iDevice)
	{
		static AtikMethod_B_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_I)GetProcAddress(hArtemisDLL, "ArtemisDeviceIsPresent");

		if (method == NULL)
			return FALSE;

		return method(iDevice);
	}
	artfn BOOL			ArtemisDevicePresent(  int iDevice)
	{
		static AtikMethod_B_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_I)GetProcAddress(hArtemisDLL, "ArtemisDevicePresent");

		if (method == NULL)
			return FALSE;

		return method(iDevice);
	}
	artfn BOOL			ArtemisDeviceInUse(    int iDevice)
	{
		static AtikMethod_B_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_I)GetProcAddress(hArtemisDLL, "ArtemisDeviceInUse");

		if (method == NULL)
			return FALSE;

		return method(iDevice);
	}

	artfn BOOL			ArtemisDeviceName(          int iDevice, char *pName)
	{
		static AtikMethod_B_IS method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_IS)GetProcAddress(hArtemisDLL, "ArtemisDeviceName");

		if (method == NULL)
			return FALSE;

		return method(iDevice, pName);
	}
	artfn BOOL			ArtemisDeviceSerial(        int iDevice, char *pSerial)
	{
		static AtikMethod_B_IS method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_IS)GetProcAddress(hArtemisDLL, "ArtemisDeviceSerial");

		if (method == NULL)
			return FALSE;

		return method(iDevice, pSerial);
	}
	artfn BOOL			ArtemisDeviceIsCamera(      int iDevice)
	{
		static AtikMethod_B_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_I)GetProcAddress(hArtemisDLL, "ArtemisDeviceIsCamera");

		if (method == NULL)
			return FALSE;

		return method(iDevice);
	}
	artfn BOOL			ArtemisDeviceHasFilterWheel(int iDevice)
	{
		static AtikMethod_B_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_I)GetProcAddress(hArtemisDLL, "ArtemisDeviceHasFilterWheel");

		if (method == NULL)
			return FALSE;

		return method(iDevice);
	}
	artfn BOOL			ArtemisDeviceHasGuidePort(  int iDevice)
	{
		static AtikMethod_B_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_I)GetProcAddress(hArtemisDLL, "ArtemisDeviceHasGuidePort");

		if (method == NULL)
			return FALSE;

		return method(iDevice);
	}

	artfn ArtemisHandle	ArtemisConnect(    int iDevice)
	{
		static AtikMethod_H_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_H_I)GetProcAddress(hArtemisDLL, "ArtemisConnect");

		if (method == NULL)
			return (ArtemisHandle)0;

		return method(iDevice);
	}
	artfn BOOL			ArtemisIsConnected(ArtemisHandle handle)
	{
		static AtikMethod_B_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_H)GetProcAddress(hArtemisDLL, "ArtemisIsConnected");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn BOOL			ArtemisDisconnect( ArtemisHandle handle)
	{
		static AtikMethod_B_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_H)GetProcAddress(hArtemisDLL, "ArtemisDisconnect");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int			ArtemisRefreshDevicesCount()
	{
		static AtikMethod_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_I)GetProcAddress(hArtemisDLL, "ArtemisRefreshDevicesCount");

		if (method == NULL)
			return FALSE;

		return method();
	}


	// ------------------- Camera Info -----------------------------------
	artfn int ArtemisCameraSerial(		   ArtemisHandle handle, int* flags, int* serial)
	{
		static AtikMethod_I_Hii method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hii)GetProcAddress(hArtemisDLL, "ArtemisCameraSerial");

		if (method == NULL)
			return FALSE;

		return method(handle, flags, serial);
	}
	artfn int ArtemisColourProperties(	   ArtemisHandle handle, ARTEMISCOLOURTYPE *colourType, int *normalOffsetX, int *normalOffsetY, int *previewOffsetX, int *previewOffsetY)
	{
		static AtikMethod_ArtemisColourProperties method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisColourProperties)GetProcAddress(hArtemisDLL, "ArtemisColourProperties");

		if (method == NULL)
			return FALSE;

		return method(handle, colourType, normalOffsetX, normalOffsetY, previewOffsetX, previewOffsetY);
	}
	artfn int ArtemisProperties(		   ArtemisHandle handle, struct ARTEMISPROPERTIES *pProp)
	{
		static AtikMethod_ArtemisProperties method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisProperties)GetProcAddress(hArtemisDLL, "ArtemisProperties");

		if (method == NULL)
			return FALSE;

		return method(handle, pProp);
	}
	artfn int ArtemisCameraConnectionState(ArtemisHandle handle, ARTEMISCONNECTIONSTATE * state)
	{
		static AtikMethod_ArtemisCameraConnectionState method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisCameraConnectionState)GetProcAddress(hArtemisDLL, "ArtemisCameraConnectionState");

		if (method == NULL)
			return FALSE;

		return method(handle, state);
	}

	// ------------------- Exposure Settings -----------------------------------
	artfn int  ArtemisBin(								ArtemisHandle handle, int  x, int  y)
	{
		static AtikMethod_I_HII method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HII)GetProcAddress(hArtemisDLL, "ArtemisBin");

		if (method == NULL)
			return FALSE;

		return method(handle, x, y);
	}
	artfn int  ArtemisGetBin(							ArtemisHandle handle, int *x, int *y)
	{
		static AtikMethod_I_Hii method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hii)GetProcAddress(hArtemisDLL, "ArtemisGetBin");

		if (method == NULL)
			return FALSE;

		return method(handle, x, y);
	}
	artfn int  ArtemisGetMaxBin(						ArtemisHandle handle, int *x, int *y)
	{
		static AtikMethod_I_Hii method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hii)GetProcAddress(hArtemisDLL, "ArtemisGetMaxBin");

		if (method == NULL)
			return FALSE;

		return method(handle, x, y);
	}
	artfn int  ArtemisGetSubframe(						ArtemisHandle handle, int *x, int *y, int *w, int *h)
	{
		static AtikMethod_I_Hiiii method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hiiii)GetProcAddress(hArtemisDLL, "ArtemisGetSubframe");

		if (method == NULL)
			return FALSE;

		return method(handle, x, y, w, h);
	}
	artfn int  ArtemisSubframe(							ArtemisHandle handle, int  x, int  y, int  w, int  h)
	{
		static AtikMethod_I_HIIII method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HIIII)GetProcAddress(hArtemisDLL, "ArtemisSubframe");

		if (method == NULL)
			return FALSE;

		return method(handle, x, y, w, h);
	}
	artfn int  ArtemisSubframePos(						ArtemisHandle handle, int  x, int y)
	{
		static AtikMethod_I_HII method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HII)GetProcAddress(hArtemisDLL, "ArtemisSubframePos");

		if (method == NULL)
			return FALSE;

		return method(handle, x, y);
	}
	artfn int  ArtemisSubframeSize(						ArtemisHandle handle, int  w, int h)
	{
		static AtikMethod_I_HII method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HII)GetProcAddress(hArtemisDLL, "ArtemisSubframeSize");

		if (method == NULL)
			return FALSE;

		return method(handle, w, h);
	}
	artfn int  ArtemisSetSubSample(						ArtemisHandle handle, bool bSub)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisSetSubSample");

		if (method == NULL)
			return FALSE;

		return method(handle, bSub);
	}
	artfn BOOL ArtemisContinuousExposingModeSupported(	ArtemisHandle handle)
	{
		static AtikMethod_B_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_H)GetProcAddress(hArtemisDLL, "ArtemisContinuousExposingModeSupported");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn BOOL ArtemisGetContinuousExposingMode(		ArtemisHandle handle)
	{
		static AtikMethod_B_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_H)GetProcAddress(hArtemisDLL, "ArtemisGetContinuousExposingMode");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int  ArtemisSetContinuousExposingMode(		ArtemisHandle handle, bool bEnable)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisSetContinuousExposingMode");

		if (method == NULL)
			return FALSE;

		return method(handle, bEnable);
	}
	artfn BOOL ArtemisGetDarkMode(						ArtemisHandle handle)
	{
		static AtikMethod_B_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_H)GetProcAddress(hArtemisDLL, "ArtemisGetDarkMode");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int  ArtemisSetDarkMode(						ArtemisHandle handle, bool bEnable)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisSetDarkMode");

		if (method == NULL)
			return FALSE;

		return method(handle, bEnable);
	}
	artfn int  ArtemisSetPreview(						ArtemisHandle handle, bool bPrev)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisSetPreview");

		if (method == NULL)
			return FALSE;

		return method(handle, bPrev);
	}
	artfn int  ArtemisAutoAdjustBlackLevel(				ArtemisHandle handle, bool bEnable)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisAutoAdjustBlackLevel");

		if (method == NULL)
			return FALSE;

		return method(handle, bEnable);
	}
	artfn int  ArtemisPrechargeMode(					ArtemisHandle handle, int mode)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisPrechargeMode");

		if (method == NULL)
			return FALSE;

		return method(handle, mode);
	}
	artfn int  ArtemisEightBitMode(						ArtemisHandle handle, bool eightbit)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisEightBitMode");

		if (method == NULL)
			return FALSE;

		return method(handle, eightbit);
	}
	artfn int  ArtemisGetEightBitMode(					ArtemisHandle handle, bool *eightbit)
	{
		static AtikMethod_I_Hb method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hb)GetProcAddress(hArtemisDLL, "ArtemisGetEightBitMode");

		if (method == NULL)
			return FALSE;

		return method(handle, eightbit);
	}
	artfn int  ArtemisStartOverlappedExposure(			ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisStartOverlappedExposure");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn BOOL ArtemisOverlappedExposureValid(			ArtemisHandle handle)
	{
		static AtikMethod_B_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_H)GetProcAddress(hArtemisDLL, "ArtemisOverlappedExposureValid");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int  ArtemisSetOverlappedExposureTime(		ArtemisHandle handle, float fSeconds)
	{
		static AtikMethod_I_HF method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HF)GetProcAddress(hArtemisDLL, "ArtemisSetOverlappedExposureTime");

		if (method == NULL)
			return FALSE;

		return method(handle, fSeconds);
	}
	artfn int  ArtemisTriggeredExposure(				ArtemisHandle handle, bool bAwaitTrigger)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisTriggeredExposure");

		if (method == NULL)
			return FALSE;

		return method(handle, bAwaitTrigger);
	}
	artfn int  ArtemisGetProcessing(					ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisGetProcessing");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int  ArtemisSetProcessing(					ArtemisHandle handle, int options)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisSetProcessing");

		if (method == NULL)
			return FALSE;

		return method(handle, options);
	}


	// ------------------- Exposures -----------------------------------
	artfn int   ArtemisStartExposure(			 ArtemisHandle handle, float seconds)
	{
		static AtikMethod_I_HF method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HF)GetProcAddress(hArtemisDLL, "ArtemisStartExposure");

		if (method == NULL)
			return FALSE;

		return method(handle, seconds);
	}
	artfn int   ArtemisStartExposureMS(			 ArtemisHandle handle, int ms)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisStartExposureMS");

		if (method == NULL)
			return FALSE;

		return method(handle, ms);
	}
	artfn int   ArtemisAbortExposure(			 ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisAbortExposure");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int   ArtemisStopExposure(			 ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisStopExposure");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn BOOL  ArtemisImageReady(				 ArtemisHandle handle)
	{
		static AtikMethod_B_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_H)GetProcAddress(hArtemisDLL, "ArtemisImageReady");

		if (method == NULL)
			return FALSE;

		return (BOOL)method(handle);
	}
	artfn int   ArtemisCameraState(				 ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisCameraState");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn float ArtemisExposureTimeRemaining(	 ArtemisHandle handle)
	{
		static AtikMethod_F_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_F_H)GetProcAddress(hArtemisDLL, "ArtemisExposureTimeRemaining");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int   ArtemisDownloadPercent(			 ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisDownloadPercent");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int   ArtemisGetImageData(			 ArtemisHandle handle, int *x, int *y, int *w, int *h, int *binx, int *biny)
	{
		static AtikMethod_I_Hiiiiii method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hiiiiii)GetProcAddress(hArtemisDLL, "ArtemisGetImageData");

		if (method == NULL)
			return FALSE;

		return method(handle, x, y, w, h, binx, biny);
	}
	artfn void* ArtemisImageBuffer(				 ArtemisHandle handle)
	{
		static AtikMethod_ArtemisImageBuffer method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisImageBuffer)GetProcAddress(hArtemisDLL, "ArtemisImageBuffer");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn float ArtemisLastExposureDuration(	 ArtemisHandle handle)
	{
		static AtikMethod_F_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_F_H)GetProcAddress(hArtemisDLL, "ArtemisLastExposureDuration");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn char* ArtemisLastStartTime(			 ArtemisHandle handle)
	{
		static AtikMethod_S_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_S_H)GetProcAddress(hArtemisDLL, "ArtemisLastStartTime");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int   ArtemisLastStartTimeMilliseconds(ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisLastStartTimeMilliseconds");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int   ArtemisClearVReg(				 ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisClearVReg");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}

	artfn BOOL ArtemisHasFastMode(ArtemisHandle handle)
	{
		static AtikMethod_B_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_H)GetProcAddress(hArtemisDLL, "ArtemisHasFastMode");

		if (method == NULL)
			return FALSE;

		return (BOOL)method(handle);
	}
	artfn BOOL ArtemisStartFastExposure(ArtemisHandle handle, int ms)
	{
		static AtikMethod_B_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_HI)GetProcAddress(hArtemisDLL, "ArtemisStartFastExposure");

		if (method == NULL)
			return FALSE;

		return (BOOL)method(handle, ms);
	}
	artfn BOOL ArtemisSetFastCallback(ArtemisHandle handle, void(*callback)(ArtemisHandle handle, int x, int y, int w, int h, int binx, int biny, void * imageBuffer))
	{
		static AtikMethod_ArtemisSetSetFastCallback method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisSetSetFastCallback)GetProcAddress(hArtemisDLL, "ArtemisSetFastCallback");

		if (method == NULL)
			return FALSE;

		return (BOOL)method(handle, callback);
	}

	// ------------------- Amplifier -----------------------------------
	artfn int  ArtemisAmplifier(		   ArtemisHandle handle, bool bOn)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisAmplifier");

		if (method == NULL)
			return FALSE;

		return method(handle, bOn);
	}
	artfn BOOL ArtemisGetAmplifierSwitched(ArtemisHandle handle)
	{
		static AtikMethod_B_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_H)GetProcAddress(hArtemisDLL, "ArtemisGetAmplifierSwitched");

		if (method == NULL)
			return FALSE;

		return (BOOL)method(handle);
	}
	artfn int  ArtemisSetAmplifierSwitched(ArtemisHandle handle, bool bSwitched)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisSetAmplifierSwitched");

		if (method == NULL)
			return FALSE;

		return method(handle, bSwitched);
	}
		
	// ------------ Camera Specific Options -------------
	artfn bool ArtemisHasCameraSpecificOption(    ArtemisHandle handle, unsigned short id)
	{
		static AtikMethod_ArtemisHasCameraSpecificOption method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisHasCameraSpecificOption)GetProcAddress(hArtemisDLL, "ArtemisHasCameraSpecificOption");

		if (method == NULL)
			return FALSE;

		return method(handle, id);
	}
	artfn int  ArtemisCameraSpecificOptionGetData(ArtemisHandle handle, unsigned short id, unsigned char * data, int dataLength, int * actualLength)
	{
		static AtikMethod_ArtemisCameraSpecificOptionGetData method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisCameraSpecificOptionGetData)GetProcAddress(hArtemisDLL, "ArtemisCameraSpecificOptionGetData");

		if (method == NULL)
			return FALSE;

		return method(handle, id, data, dataLength, *actualLength);
	}
	artfn int  ArtemisCameraSpecificOptionSetData(ArtemisHandle handle, unsigned short id, unsigned char * data, int dataLength)
	{
		static AtikMethod_ArtemisCameraSpecificOptionSetData method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisCameraSpecificOptionSetData)GetProcAddress(hArtemisDLL, "ArtemisCameraSpecificOptionSetData");

		if (method == NULL)
			return FALSE;

		return method(handle, id, data, dataLength);
	}

	// ------------------- Column Repair ----------------------------------	
	artfn int ArtemisSetColumnRepairColumns(		ArtemisHandle handle, int   nColumn, unsigned short * columns)
	{
		static AtikMethod_ArtemisSetColumnRepairColumns method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisSetColumnRepairColumns)GetProcAddress(hArtemisDLL, "ArtemisSetColumnRepairColumns");

		if (method == NULL)
			return FALSE;

		return method(handle, nColumn, columns);
	}
	artfn int ArtemisGetColumnRepairColumns(		ArtemisHandle handle, int * nColumn, unsigned short * columns)
	{
		static AtikMethod_ArtemisGetColumnRepairColumns method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisGetColumnRepairColumns)GetProcAddress(hArtemisDLL, "ArtemisGetColumnRepairColumns");

		if (method == NULL)
			return FALSE;

		return method(handle, nColumn, columns);
	}
	artfn int ArtemisClearColumnRepairColumns(		ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisClearColumnRepairColumns");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int ArtemisSetColumnRepairFixColumns(		ArtemisHandle handle, bool value)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisSetColumnRepairFixColumns");

		if (method == NULL)
			return FALSE;

		return method(handle, value);
	}
	artfn int ArtemisGetColumnRepairFixColumns(		ArtemisHandle handle, bool * value)
	{
		static AtikMethod_I_Hb method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hb)GetProcAddress(hArtemisDLL, "ArtemisGetColumnRepairFixColumns");

		if (method == NULL)
			return FALSE;

		return method(handle, value);
	}
	artfn int ArtemisGetColumnRepairCanFixColumns(	ArtemisHandle handle, bool * value)
	{
		static AtikMethod_I_Hb method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hb)GetProcAddress(hArtemisDLL, "ArtemisGetColumnRepairCanFixColumns");

		if (method == NULL)
			return FALSE;

		return method(handle, value);
	}

	// ---------------- EEPROM -------------------------
	artfn int ArtemisCanInteractWithEEPROM(ArtemisHandle handle, bool * canInteract)
	{
		static AtikMethod_I_Hb method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hb)GetProcAddress(hArtemisDLL, "ArtemisCanInteractWithEEPROM");

		if (method == NULL)
			return FALSE;

		return method(handle, canInteract);
	}
	artfn int ArtemisWriteToEEPROM(		   ArtemisHandle handle, char * password, int address, int length, const unsigned char * data)
	{
		static AtikMethod_ArtemisWriteToEEPROM method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisWriteToEEPROM)GetProcAddress(hArtemisDLL, "ArtemisWriteToEEPROM");

		if (method == NULL)
			return FALSE;

		return method(handle, password, address, length, data);
	}
	artfn int ArtemisReadFromEEPROM(	   ArtemisHandle handle, char * password, int address, int length,       unsigned char * data)
	{
		static AtikMethod_ArtemisReadFromEEPROM method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisReadFromEEPROM)GetProcAddress(hArtemisDLL, "ArtemisReadFromEEPROM");

		if (method == NULL)
			return FALSE;

		return method(handle, password, address, length, data);
	}


	// ------------------- Filter Wheel -----------------------------------
	artfn int			ArtemisFilterWheelInfo(ArtemisHandle handle, int *numFilters, int *moving, int *currentPos, int *targetPos)
	{
		static AtikMethod_I_Hiiii method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hiiii)GetProcAddress(hArtemisDLL, "ArtemisFilterWheelInfo");

		if (method == NULL)
			return FALSE;

		return method(handle, numFilters, moving, currentPos, targetPos);
	}
	artfn int			ArtemisFilterWheelMove(ArtemisHandle handle, int targetPos)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisFilterWheelMove");

		if (method == NULL)
			return FALSE;

		return method(handle, targetPos);
	}
	artfn BOOL			ArtemisEFWIsPresent(int i)
	{
		static AtikMethod_B_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_I)GetProcAddress(hArtemisDLL, "ArtemisEFWIsPresent");

		if (method == NULL)
			return FALSE;

		return (BOOL)method(i);
	}
	artfn int			ArtemisEFWGetDeviceDetails(int i, ARTEMISEFWTYPE * type, char * serialNumber)
	{
		static AtikMethod_ArtemisEFWGetDeviceDetails method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisEFWGetDeviceDetails)GetProcAddress(hArtemisDLL, "ArtemisEFWGetDeviceDetails");

		if (method == NULL)
			return FALSE;

		return method(i, type, serialNumber);
	}
	artfn ArtemisHandle ArtemisEFWConnect(int i)
	{
		static AtikMethod_H_I method = NULL;

		if (method == NULL)
			method = (AtikMethod_H_I)GetProcAddress(hArtemisDLL, "ArtemisEFWConnect");

		if (method == NULL)
			return FALSE;

		return method(i);
	}
	artfn bool			ArtemisEFWIsConnected(ArtemisHandle handle)
	{
		static AtikMethod_B_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_H)GetProcAddress(hArtemisDLL, "ArtemisEFWIsConnected");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int			ArtemisEFWDisconnect( ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisEFWDisconnect");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int			ArtemisEFWGetDetails( ArtemisHandle handle, ARTEMISEFWTYPE * type, char * serialNumber)
	{
		static AtikMethod_ArtemisEFWGetDetails method = NULL;

		if (method == NULL)
			method = (AtikMethod_ArtemisEFWGetDetails)GetProcAddress(hArtemisDLL, "ArtemisEFWGetDetails");

		if (method == NULL)
			return FALSE;

		return method(handle, type, serialNumber);
	}
	artfn int			ArtemisEFWNmrPosition(ArtemisHandle handle, int * nPosition)
	{
		static AtikMethod_I_Hi method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hi)GetProcAddress(hArtemisDLL, "ArtemisEFWNmrPosition");

		if (method == NULL)
			return FALSE;

		return method(handle, nPosition);
	}
	artfn int			ArtemisEFWSetPosition(ArtemisHandle handle, int   iPosition)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisEFWSetPosition");

		if (method == NULL)
			return FALSE;

		return method(handle, iPosition);
	}
	artfn int			ArtemisEFWGetPosition(ArtemisHandle handle, int * iPosition, bool * isMoving)
	{
		static AtikMethod_I_Hib method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hib)GetProcAddress(hArtemisDLL, "ArtemisEFWGetPosition");

		if (method == NULL)
			return FALSE;

		return method(handle, iPosition, isMoving);
	}
	
	// ------------------- Firmware ----------------------------------------	
	artfn bool ArtemisCanUploadFirmware(ArtemisHandle handle)
	{
		static AtikMethod_B_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_B_H)GetProcAddress(hArtemisDLL, "ArtemisCanUploadFirmware");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int  ArtemisUploadFirmware(   ArtemisHandle handle, char * fileName, char * password)
	{
		static AtikMethod_I_HSS method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HSS)GetProcAddress(hArtemisDLL, "ArtemisUploadFirmware");

		if (method == NULL)
			return FALSE;

		return method(handle, fileName, password);
	}

	// ------------------- Gain -----------------------------------
	artfn int ArtemisGetGain(ArtemisHandle handle, bool isPreview, int *gain, int *offset)
	{
		static AtikMethod_I_HBii method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HBii)GetProcAddress(hArtemisDLL, "ArtemisGetGain");

		if (method == NULL)
			return FALSE;

		return method(handle, isPreview, gain, offset);
	}
	artfn int ArtemisSetGain(ArtemisHandle handle, bool isPreview, int  gain, int  offset)
	{
		static AtikMethod_I_HBII method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HBII)GetProcAddress(hArtemisDLL, "ArtemisSetGain");

		if (method == NULL)
			return FALSE;

		return method(handle, isPreview, gain, offset);
	}

	// ------------------- GPIO -----------------------------------
	artfn int ArtemisGetGpioInformation(ArtemisHandle handle, int* lineCount, int* lineValues)
	{
		static AtikMethod_I_Hii method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hii)GetProcAddress(hArtemisDLL, "ArtemisGetGpioInformation");

		if (method == NULL)
			return FALSE;

		return method(handle, lineCount, lineValues);
	}
	artfn int ArtemisSetGpioDirection(  ArtemisHandle handle, int directionMask)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisSetGpioDirection");

		if (method == NULL)
			return FALSE;

		return method(handle, directionMask);
	}
	artfn int ArtemisSetGpioValues(     ArtemisHandle handle, int lineValues)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisSetGpioValues");

		if (method == NULL)
			return FALSE;

		return method(handle, lineValues);
	}

	// ------------------- Guiding -----------------------------------
	artfn int ArtemisGuide(					   ArtemisHandle handle, int axis)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisGuide");

		if (method == NULL)
			return FALSE;

		return method(handle, axis);
	}
	artfn int ArtemisGuidePort(				   ArtemisHandle handle, int nibble)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisGuidePort");

		if (method == NULL)
			return FALSE;

		return method(handle, nibble);
	}
	artfn int ArtemisPulseGuide(			   ArtemisHandle handle, int axis, int milli)
	{
		static AtikMethod_I_HII method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HII)GetProcAddress(hArtemisDLL, "ArtemisPulseGuide");

		if (method == NULL)
			return FALSE;

		return method(handle, axis, milli);
	}
	artfn int ArtemisStopGuiding(			   ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisStopGuiding");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int ArtemisStopGuidingBeforeDownload(ArtemisHandle handle, bool bEnable)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisStopGuidingBeforeDownload");

		if (method == NULL)
			return FALSE;

		return method(handle, bEnable);
	}

	// ------------------- Hot Pixel Remover ----------------------

	int ArtemisHotPixelAutoRemoval(ArtemisHandle handle, bool enable)
	{
		static AtikMethod_I_HB method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HB)GetProcAddress(hArtemisDLL, "ArtemisAutoHotPixelRemoval");

		if (method == NULL)
			return FALSE;

		return method(handle, enable);
	}

	int ArtemisHotPixelAdvancedRemoval(ArtemisHandle handle, bool enable, bool darkFrame, 
									   bool checkForAdjacentHotPixels, HotPixelSensitivity hps)
	{
		static AtikMethod_I_HBBBHPS method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HBBBHPS)GetProcAddress(hArtemisDLL, "ArtemisAdvancedHotPixelRemoval");

		if (method == NULL)
			return FALSE;

		return method(handle, enable, darkFrame, checkForAdjacentHotPixels, hps);
	}

	int ArtemisHotPixelAdvancedStartCalculateHotPixels(ArtemisHandle handle, float exposureLength)
	{
		static AtikMethod_I_HF method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HF)GetProcAddress(hArtemisDLL, "ArtemisHotPixelAdvancedStartCalculateHotPixels");

		if (method == NULL)
			return FALSE;

		return method(handle, exposureLength);
	}

	int ArtemisHotPixelAdvancedCalculationComplete(ArtemisHandle handle, bool* calculationComplete)
	{
		static AtikMethod_I_Hb method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hb)GetProcAddress(hArtemisDLL, "ArtemisHotPixelAdvancedCalculationComplete");

		if (method == NULL)
			return FALSE;

		return method(handle, calculationComplete);
	}

	// ------------------- Lens -----------------------------------
	artfn int ArtemisGetLensAperture(ArtemisHandle handle, int* aperture)
	{
		static AtikMethod_I_Hi method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hi)GetProcAddress(hArtemisDLL, "ArtemisGetLensAperture");

		if (method == NULL)
			return FALSE;

		return method(handle, aperture);
	}
	artfn int ArtemisGetLensFocus(   ArtemisHandle handle, int* focus)
	{
		static AtikMethod_I_Hi method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hi)GetProcAddress(hArtemisDLL, "ArtemisGetLensFocus");

		if (method == NULL)
			return FALSE;

		return method(handle, focus);
	}
	artfn int ArtemisGetLensLimits(  ArtemisHandle handle, int* apertureMin, int* apertureMax, int* focusMin, int* focusMax)
	{
		static AtikMethod_I_Hiiii method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hiiii)GetProcAddress(hArtemisDLL, "ArtemisGetLensLimits");

		if (method == NULL)
			return FALSE;

		return method(handle, apertureMin, apertureMax, focusMin, focusMax);
	}
	artfn int ArtemisInitializeLens( ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisInitializeLens");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int ArtemisSetLensAperture(ArtemisHandle handle, int aperture)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisSetLensAperture");

		if (method == NULL)
			return FALSE;

		return method(handle, aperture);
	}
	artfn int ArtemisSetLensFocus(   ArtemisHandle handle, int focus)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisSetLensFocus");

		if (method == NULL)
			return FALSE;

		return method(handle, focus);
	}

	// ------------------- Shutter ----------------------------------		
	artfn int ArtemisCanControlShutter( ArtemisHandle handle, bool * canControl)
	{
		static AtikMethod_I_Hb method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hb)GetProcAddress(hArtemisDLL, "ArtemisCanControlShutter");

		if (method == NULL)
			return FALSE;

		return method(handle, canControl);
	}
	artfn int ArtemisOpenShutter(		ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisOpenShutter");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int ArtemisCloseShutter(	    ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisCloseShutter");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int ArtemisCanSetShutterSpeed(ArtemisHandle handle, bool *canSetShutterSpeed)
	{
		static AtikMethod_I_Hb method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hb)GetProcAddress(hArtemisDLL, "ArtemisCanSetShutterSpeed");

		if (method == NULL)
			return FALSE;

		return method(handle, canSetShutterSpeed);
	}
	artfn int ArtemisGetShutterSpeed(	ArtemisHandle handle, int *speed)
	{
		static AtikMethod_I_Hi method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hi)GetProcAddress(hArtemisDLL, "ArtemisGetShutterSpeed");

		if (method == NULL)
			return FALSE;

		return method(handle, speed);
	}
	artfn int ArtemisSetShutterSpeed(	ArtemisHandle handle, int  speed)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisSetShutterSpeed");

		if (method == NULL)
			return FALSE;

		return method(handle, speed);
	}

	// ------------------- Temperature -----------------------------------
	artfn int ArtemisTemperatureSensorInfo(ArtemisHandle handle, int sensor, int* temperature)
	{
		static AtikMethod_I_HIi method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HIi)GetProcAddress(hArtemisDLL, "ArtemisTemperatureSensorInfo");

		if (method == NULL)
			return FALSE;

		return method(handle, sensor, temperature);
	}
	artfn int ArtemisSetCooling(		   ArtemisHandle handle, int setpoint)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisSetCooling");

		if (method == NULL)
			return FALSE;

		return method(handle, setpoint);
	}
	artfn int ArtemisSetCoolingPower(      ArtemisHandle handle, int power)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisSetCoolingPower");

		if (method == NULL)
			return FALSE;

		return method(handle, power);
	}
	artfn int ArtemisCoolingInfo(		   ArtemisHandle handle, int* flags, int* level, int* minlvl, int* maxlvl, int* setpoint)
	{
		static AtikMethod_I_Hiiiii method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hiiiii)GetProcAddress(hArtemisDLL, "ArtemisCoolingInfo");

		if (method == NULL)
			return FALSE;

		return method(handle, flags, level, minlvl, maxlvl, setpoint);
	}
	artfn int ArtemisCoolerWarmUp(		   ArtemisHandle handle)
	{
		static AtikMethod_I_H method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_H)GetProcAddress(hArtemisDLL, "ArtemisCoolerWarmUp");

		if (method == NULL)
			return FALSE;

		return method(handle);
	}
	artfn int ArtemisGetWindowHeaterPower( ArtemisHandle handle, int* windowHeaterPower)
	{
		static AtikMethod_I_Hi method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_Hi)GetProcAddress(hArtemisDLL, "ArtemisGetWindowHeaterPower");

		if (method == NULL)
			return FALSE;

		return method(handle, windowHeaterPower);
	}
	artfn int ArtemisSetWindowHeaterPower( ArtemisHandle handle, int  windowHeaterPower)
	{
		static AtikMethod_I_HI method = NULL;

		if (method == NULL)
			method = (AtikMethod_I_HI)GetProcAddress(hArtemisDLL, "ArtemisSetWindowHeaterPower");

		if (method == NULL)
			return FALSE;

		return method(handle, windowHeaterPower);
	}
	
	// Try to load the Artemis DLL.
	// Returns true if loaded ok.
	bool artfn ArtemisLoadDLL(const char *fileName)
	{
		std::string fileStr = fileName;

#if _WIN32
		hArtemisDLL = LoadLibraryA(fileStr.c_str());
#else
		hArtemisDLL = dlopen(fileStr.c_str(), RTLD_NOW);
		char * error = dlerror();
		std::cout << error;
		fprintf(stderr, "Error: %s\r\n", error);
#endif

		if (hArtemisDLL == NULL)
			return false;

		return true;
	}

	// Unload the Artemis DLL.
	void artfn ArtemisUnLoadDLL()
	{
		if (hArtemisDLL != NULL)
		{
#if _WIN32
			FreeLibrary(hArtemisDLL);
#else
			dlclose(hArtemisDLL);
#endif
		}

		hArtemisDLL = NULL;
	}
}